/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.mixins;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.AIBattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.interpreter.instructions.RequestInstruction;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMakeChoicePacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleQueueRequestPacket;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.battle.BattleState;
import kotlin.Unit;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RequestInstruction.class})
public abstract class RequestInstructionMixin {
    @Shadow(remap=false)
    public abstract BattleMessage getMessage();

    @Shadow(remap=false)
    public abstract BattleActor getBattleActor();

    @Inject(method={"invoke"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void inject$invoke(PokemonBattle battle, CallbackInfo ci) {
        if (BattleState.findFirst(battle) != null) {
            battle.log("Request Instruction");
            if (this.getMessage().getRawMessage().contains("teamPreview")) {
                ci.cancel();
                return;
            }
            ShowdownActionRequest request = (ShowdownActionRequest)BattleRegistry.INSTANCE.getGson().fromJson(this.getMessage().getRawMessage().split("\\|request\\|")[1], ShowdownActionRequest.class);
            BattleActor battleActor = this.getBattleActor();
            request.sanitize(battle, battleActor);
            BattleStates.get(battle).getActorState(battleActor).nextRequest();
            battle.dispatchGo(() -> {
                battleActor.sendUpdate((NetworkPacket)new BattleQueueRequestPacket(request));
                battleActor.setRequest(request);
                battleActor.getResponses().clear();
                if (request.getForceSwitch().contains(true)) {
                    if (battleActor instanceof AIBattleActor) {
                        battle.dispatchGo(() -> {
                            battleActor.setMustChoose(true);
                            battleActor.sendUpdate((NetworkPacket)new BattleMakeChoicePacket());
                            return Unit.INSTANCE;
                        });
                    } else {
                        battle.doWhenClear(() -> {
                            battleActor.setMustChoose(true);
                            battleActor.sendUpdate((NetworkPacket)new BattleMakeChoicePacket());
                            return Unit.INSTANCE;
                        });
                    }
                }
                return Unit.INSTANCE;
            });
            ci.cancel();
        }
    }
}

